<?php
/**
 * Add Contact List
 *
 * @package     AutomatorWP\Integrations\Autonami\Actions\Add_Contact_List
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly

if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Autonami_Add_Contact_List extends AutomatorWP_Integration_Action {

    public $integration = 'autonami';
    public $action = 'autonami_add_contact_list';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add contact to list', 'automatorwp-pro' ),
            'select_option'     => __( 'Add contact to <strong>list</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Contact. %2$s: List */
            'edit_label'        => sprintf( __( 'Add %1$s to %2$s', 'automatorwp-pro' ), '{contact}', '{list}' ),
            /* translators: %1$s: Contact. %2$s: List */
            'log_label'         => sprintf( __( 'Add %1$s to %2$s', 'automatorwp-pro' ), '{contact}','{list}' ),
            'options'           => array(
                'list' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'list',
                    'option_default'    => __( 'List', 'automatorwp-pro' ),
                    'name'              => __( 'List:', 'automatorwp-pro' ),
                    'option_none'       => false,
                    'action_cb'         => 'automatorwp_autonami_get_lists',
                    'options_cb'        => 'automatorwp_autonami_options_cb_list',
                    'placeholder'       => __( 'Select a list', 'automatorwp-pro' ),
                    'default'           => ''
                ) ),
                'contact' => array(
                    'from' => 'email',
                    'default' => __( 'contact', 'automatorwp-pro' ),
                    'fields' => array(
                        'email' => array(
                            'name' => __( 'Contact Email:', 'automatorwp-pro' ),
                            'desc' => __( 'The contact email address.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'required'  => true,
                            'default' => ''
                        ),
                     ) )
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        global $wpdb;

        // Shorthand
        $list_id = $action_options['list'];
        $contact_email = $action_options['email'];
        $this->result = '';

        // Bail if empty tag to assign
        if( empty( $list_id ) ) {
            return;
        }

        $list = array(
			array(
				'id' => $list_id,
			),
		);

       
        $contact = new BWFCRM_Contact( $contact_email );

        // Bail if contact not exists
        if ( ! $contact->is_contact_exists() ){
            return;
        }

		$response = $contact->add_lists( $list );

        if ( empty ( $response ) ){
            $this->result = __( 'Contact is already included in the list', 'automatorwp-pro' );
            return;
        } else{
            $this->result = __( 'Contact added to list successfully', 'automatorwp-pro' );
        }

    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;
    }

}

new AutomatorWP_Autonami_Add_Contact_List();